<?php

function pf_check_install()
{
    if (file_exists(ABSPATH . 'configs/config.php')) {
        return true;
    }
    return false;
}

function pf_check_exists_config()
{
    if (file_exists(ABSPATH . 'configs/config-sample.php')) {
        return true;
    }
    return false;
}

function pf_check_exists_sql()
{
    if (file_exists(ABSPATH . 'installs/data/pageflex.sql')) {
        return true;
    }
    return false;
}

function pf_require($files)
{
    if (file_exists($files)) {
        require $files;
    }
}

function pf_get_header()
{
    pf_require(ABSPATH . 'installs/includes/header.php');
}

function pf_get_footer()
{
    pf_require(ABSPATH . 'installs/includes/footer.php');
}

function pf_require_db()
{
    pf_require(ABSPATH . 'includes/functions.php');
    pf_require(ABSPATH . 'admin/includes/option.php');
    pf_require(ABSPATH . 'includes/pf-class.php');
}

function pf_alert_message($message, $type = 'danger')
{

    $html = '<div class="alert alert-' . $type . ' fade in">';
    $html .= '<button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>';
    if ($type === 'danger') {
        $type = 'Errors';
    }
    $html .= '<h4>' . ucwords($type) . '!</h4>';
    if (is_array($message)) {
        foreach ($message as $item) {
            $html .= "<p>{$item}</p>";
        }
    } else {
        $html .= "<p>{$message}</p>";
    }
    $html .= '</div>';
    return $html;
}

//Check and display error validator
function has_error($key, $data = array())
{
    if (isset($data[$key])) {
        return true;
    }
    return false;
}

function state_validator($key, $data = array())
{
    $status = '';
    if (has_error($key, $data)) {
        $status = 'has-error';
    } elseif (!empty($data)) {
        $status = 'has-success';
    }
    return $status;
}

function alert_error_validator($key, $data = array(), $return = false)
{
    if (has_error($key, $data)) {
        foreach ($data[$key] as $value) {
            $error = "<p class='help-block'>{$value}</p>";
            if ($return) {
                return $error;
            }
            echo $error;
        }
    }
}

//Clean XSS
function e($data)
{
    $data = str_replace(array('&amp;', '&lt;', '&gt;'), array(
        '&amp;amp;', '&amp;lt;', '&amp;gt;'), $data);
    $data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
    $data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
    $data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');
    $data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20] *r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
    $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
    $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00- \x20]*:* [^>]*+>#iu', '$1>', $data);
    $data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);
    do {
        $old_data = $data;
        $data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
    } while ($old_data !== $data);
    return $data;
}

function value_input($key)
{
    return isset($_POST[$key]) ? e($_POST[$key]) : '';
}

function site_url($url)
{
    $protocol = (!empty($_SERVER ['HTTPS']) && $_SERVER ['HTTPS'] !== 'off' || $_SERVER ['SERVER_PORT'] == 443) ? "https://" : "http://";
    $domainName = $_SERVER ['HTTP_HOST'];
    return $protocol . $domainName . RELATIVE_PATH . $url;
}

function list_table_drop()
{
    $data = array(
        'pf_categories', 'pf_comments', 'pf_galleries', 'pf_options', 'pf_pages', 'pf_portfolios', '	pf_portfolio_categories', 'pf_portfolio_meta', 'pf_posts', 'pf_post_tags', 'pf_role', 'pf_tags', 'pf_testimonials', 'pf_users', 'pf_announcement', 'pf_ratings'
    );

    return implode(',', $data);
}
